/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.ZoneChangeTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

public class DiesSourceTriggeredAbility
extends ZoneChangeTriggeredAbility {
    public DiesSourceTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, Zone.GRAVEYARD, effect, "When {this} dies, ", optional);
        this.withRuleTextReplacement(true);
    }

    public DiesSourceTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    protected DiesSourceTriggeredAbility(DiesSourceTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public DiesSourceTriggeredAbility copy() {
        return new DiesSourceTriggeredAbility(this);
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent() || !event.getTargetId().equals(this.getSourceId())) {
            return false;
        }
        this.getEffects().setValue("permanentLeftBattlefield", zEvent.getTarget());
        return true;
    }

    @Override
    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger(this, sourceObject, event, game);
    }
}

