/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class DrawNthCardWatcher
extends Watcher {
    private final Map<UUID, List<UUID>> playerDrawEventMap = new HashMap<UUID, List<UUID>>();

    DrawNthCardWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DREW_CARD) {
            this.playerDrawEventMap.computeIfAbsent(event.getPlayerId(), x -> new ArrayList()).add(event.getId());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.playerDrawEventMap.clear();
    }

    static int checkEvent(UUID playerId, UUID eventId, Game game) {
        return game.getState().getWatcher(DrawNthCardWatcher.class).playerDrawEventMap.getOrDefault(playerId, Collections.emptyList()).indexOf(eventId);
    }
}

