/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeBatchEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

public class EntersBattlefieldOneOrMoreTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<ZoneChangeEvent> {
    private final FilterPermanent filter;
    private final TargetController targetController;

    public EntersBattlefieldOneOrMoreTriggeredAbility(Effect effect, FilterPermanent filter, TargetController targetController) {
        super(Zone.BATTLEFIELD, effect);
        this.filter = filter;
        this.targetController = targetController;
        this.setTriggerPhrase(this.generateTriggerPhrase());
    }

    protected EntersBattlefieldOneOrMoreTriggeredAbility(EntersBattlefieldOneOrMoreTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
        this.targetController = ability.targetController;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_BATCH;
    }

    @Override
    public boolean checkEvent(ZoneChangeEvent event, Game game) {
        if (event.getToZone() != Zone.BATTLEFIELD) {
            return false;
        }
        Permanent permanent = event.getTarget();
        if (permanent == null || !this.filter.match(permanent, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        switch (this.targetController) {
            case YOU: {
                return this.isControlledBy(permanent.getControllerId());
            }
            case OPPONENT: {
                return game.getOpponents(this.getControllerId()).contains(permanent.getControllerId());
            }
        }
        throw new IllegalArgumentException("Unsupported TargetController in EntersBattlefieldOneOrMoreTriggeredAbility: " + (Object)((Object)this.targetController));
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        return !this.getFilteredEvents((ZoneChangeBatchEvent)event, game).isEmpty();
    }

    @Override
    public EntersBattlefieldOneOrMoreTriggeredAbility copy() {
        return new EntersBattlefieldOneOrMoreTriggeredAbility(this);
    }

    private String generateTriggerPhrase() {
        StringBuilder sb = new StringBuilder("Whenever one or more " + this.filter.getMessage());
        switch (this.targetController) {
            case YOU: {
                if (this.filter.getMessage().contains("you control")) {
                    sb.append(" enter, ");
                    break;
                }
                sb.append(" you control enter, ");
                break;
            }
            case OPPONENT: {
                sb.append(" enter under an opponent's control, ");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported TargetController in EntersBattlefieldOneOrMoreTriggeredAbility: " + (Object)((Object)this.targetController));
            }
        }
        return sb.toString();
    }
}

