/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

public class EntersBattlefieldOrLeavesSourceTriggeredAbility
extends TriggeredAbilityImpl {
    public EntersBattlefieldOrLeavesSourceTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setLeavesTheBattlefieldTrigger(true);
        this.setTriggerPhrase("When {this} enters or leaves the battlefield, ");
    }

    protected EntersBattlefieldOrLeavesSourceTriggeredAbility(EntersBattlefieldOrLeavesSourceTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public EntersBattlefieldOrLeavesSourceTriggeredAbility copy() {
        return new EntersBattlefieldOrLeavesSourceTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && event.getTargetId().equals(this.getSourceId())) {
            return true;
        }
        return event.getType() == GameEvent.EventType.ZONE_CHANGE && event.getTargetId().equals(this.getSourceId()) && (zEvent = (ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD;
    }
}

