/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.ExpendValue;
import mage.abilities.common.ExpendWatcher;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

public class ExpendTriggeredAbility
extends TriggeredAbilityImpl {
    private static final Hint hint = new ValueHint("Mana you expended this turn", ExpendValue.instance);
    private final Expend amount;

    public ExpendTriggeredAbility(Effect effect, Expend amount) {
        this(effect, amount, false);
    }

    public ExpendTriggeredAbility(Effect effect, Expend amount, boolean optional) {
        this(Zone.BATTLEFIELD, effect, amount, optional);
    }

    public ExpendTriggeredAbility(Zone zone, Effect effect, Expend amount, boolean optional) {
        super(zone, effect, optional);
        this.amount = amount;
        this.setTriggerPhrase("Whenever you expend " + amount.getAmount() + ", ");
        this.addWatcher(new ExpendWatcher());
        this.addHint(hint);
    }

    private ExpendTriggeredAbility(ExpendTriggeredAbility ability) {
        super(ability);
        this.amount = ability.amount;
    }

    @Override
    public ExpendTriggeredAbility copy() {
        return new ExpendTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MANA_PAID;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        return ExpendWatcher.checkExpend(this.getControllerId(), event, this.amount, game);
    }

    public static enum Expend {
        FOUR(4),
        SIX(6),
        EIGHT(8);

        private final int amount;

        public int getAmount() {
            return this.amount;
        }

        private Expend(int amount) {
            this.amount = amount;
        }
    }
}

