/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.GainLifeCondition;
import mage.abilities.common.GainLifeFirstTimeWatcher;
import mage.abilities.effects.Effect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

public class GainLifeFirstTimeTriggeredAbility
extends TriggeredAbilityImpl {
    private static final Hint hint = new ConditionHint(GainLifeCondition.instance);
    private final boolean when;

    public GainLifeFirstTimeTriggeredAbility(Effect effect) {
        this(Zone.BATTLEFIELD, effect, false, false);
    }

    public GainLifeFirstTimeTriggeredAbility(Zone zone, Effect effect, boolean optional, boolean when) {
        super(zone, effect, optional);
        this.when = when;
        this.addWatcher(new GainLifeFirstTimeWatcher());
        this.addHint(hint);
        this.setTriggerPhrase("When" + (when ? "" : "ever") + " you gain life for the first time each turn, ");
    }

    protected GainLifeFirstTimeTriggeredAbility(GainLifeFirstTimeTriggeredAbility ability) {
        super(ability);
        this.when = ability.when;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.GAINED_LIFE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        GainLifeFirstTimeWatcher watcher = game.getState().getWatcher(GainLifeFirstTimeWatcher.class);
        return watcher != null && watcher.checkEvent(this.getControllerId(), event);
    }

    @Override
    public GainLifeFirstTimeTriggeredAbility copy() {
        return new GainLifeFirstTimeTriggeredAbility(this);
    }
}

