/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

public class LeavesBattlefieldAllTriggeredAbility
extends TriggeredAbilityImpl {
    protected FilterPermanent filter;
    protected SetTargetPointer setTargetPointer;

    public LeavesBattlefieldAllTriggeredAbility(Effect effect, FilterPermanent filter) {
        this(effect, filter, false);
    }

    public LeavesBattlefieldAllTriggeredAbility(Effect effect, FilterPermanent filter, boolean optional) {
        this(Zone.BATTLEFIELD, effect, filter, optional);
    }

    public LeavesBattlefieldAllTriggeredAbility(Zone zone, Effect effect, FilterPermanent filter, boolean optional) {
        this(zone, effect, filter, optional, SetTargetPointer.NONE);
    }

    public LeavesBattlefieldAllTriggeredAbility(Zone zone, Effect effect, FilterPermanent filter, boolean optional, SetTargetPointer setTargetPointer) {
        super(zone, effect, optional);
        this.filter = filter;
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase("Whenever " + filter.getMessage() + " leaves the battlefield, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    protected LeavesBattlefieldAllTriggeredAbility(LeavesBattlefieldAllTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public LeavesBattlefieldAllTriggeredAbility copy() {
        return new LeavesBattlefieldAllTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        UUID targetId;
        Permanent permanent;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() == Zone.BATTLEFIELD && this.filter.match(permanent = game.getPermanentOrLKIBattlefield(targetId = event.getTargetId()), this.getControllerId(), (Ability)this, game)) {
            if (this.setTargetPointer != SetTargetPointer.NONE) {
                for (Effect effect : this.getEffects()) {
                    switch (this.setTargetPointer) {
                        case PERMANENT: {
                            effect.setTargetPointer(new FixedTarget(permanent, game));
                            break;
                        }
                        case PLAYER: {
                            effect.setTargetPointer(new FixedTarget(permanent.getControllerId()));
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }
}

