/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.LicidContinuousEffect;
import mage.abilities.common.LicidSpecialAction;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.CreateSpecialActionEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

class LicidEffect
extends OneShotEffect {
    private final ManaCost specialActionCost;

    LicidEffect(ManaCost specialActionCost) {
        super(Outcome.Neutral);
        this.specialActionCost = specialActionCost;
        this.staticText = "{this} loses this ability and becomes an Aura enchantment with enchant creature. Attach it to target creature. You may pay " + specialActionCost.getText() + " to end this effect";
    }

    LicidEffect(LicidEffect effect) {
        super(effect);
        this.specialActionCost = effect.specialActionCost;
    }

    @Override
    public LicidEffect copy() {
        return new LicidEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent licid = source.getSourcePermanentIfItStillExists(game);
        if (licid != null) {
            UUID messageId = UUID.randomUUID();
            LicidContinuousEffect effect = new LicidContinuousEffect(messageId);
            effect.setTargetPointer(new FixedTarget(licid, game));
            game.addEffect(effect, source);
            new AttachEffect(Outcome.Neutral).apply(game, source);
            LicidSpecialAction specialAction = new LicidSpecialAction(this.specialActionCost, messageId, licid.getIdName());
            new CreateSpecialActionEffect(specialAction).apply(game, source);
            return true;
        }
        return false;
    }
}

