/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.common.ControllerSpeedCount;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class MaxSpeedAbilityEffect
extends ContinuousEffectImpl {
    private final Ability ability;

    private static Duration getDuration(Ability ability) {
        switch (ability.getZone()) {
            case BATTLEFIELD: {
                return Duration.WhileOnBattlefield;
            }
            case GRAVEYARD: {
                return Duration.WhileInGraveyard;
            }
        }
        return Duration.Custom;
    }

    MaxSpeedAbilityEffect(Ability ability) {
        super(MaxSpeedAbilityEffect.getDuration(ability), Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.ability = ability;
        this.ability.setRuleVisible(false);
    }

    private MaxSpeedAbilityEffect(MaxSpeedAbilityEffect effect) {
        super(effect);
        this.ability = effect.ability;
    }

    @Override
    public MaxSpeedAbilityEffect copy() {
        return new MaxSpeedAbilityEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (ControllerSpeedCount.instance.calculate(game, source, null) < 4) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            permanent.addAbility(this.ability, source.getSourceId(), game);
            return true;
        }
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        game.getState().addOtherAbility(card, this.ability);
        return true;
    }

    @Override
    public String getText(Mode mode) {
        return "Max speed &mdash; " + CardUtil.getTextWithFirstCharUpperCase(this.ability.getRule());
    }
}

