/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.MilledCardEvent;

public class MillTriggeredAbility
extends TriggeredAbilityImpl {
    private final TargetController targetController;
    private final FilterCard filter;

    public MillTriggeredAbility(Zone zone, Effect effect, TargetController targetController, FilterCard filter, boolean optional) {
        super(zone, effect, optional);
        this.targetController = targetController;
        this.filter = filter;
        this.setTriggerPhrase(this.generateTriggerPhrase());
    }

    private MillTriggeredAbility(MillTriggeredAbility ability) {
        super(ability);
        this.targetController = ability.targetController;
        this.filter = ability.filter;
    }

    @Override
    public MillTriggeredAbility copy() {
        return new MillTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MILLED_CARD;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        UUID playerId = event.getPlayerId();
        switch (this.targetController) {
            case ANY: {
                break;
            }
            case OPPONENT: {
                if (game.getOpponents(this.getControllerId()).contains(playerId)) break;
                return false;
            }
            default: {
                throw new IllegalArgumentException("Wrong code usage. targetController not yet supported: " + (Object)((Object)this.targetController));
            }
        }
        Card card = ((MilledCardEvent)event).getCard(game);
        return card != null && this.filter.match(card, this.getControllerId(), this, game);
    }

    private String generateTriggerPhrase() {
        String text = "Whenever ";
        switch (this.targetController) {
            case ANY: {
                text = text + "a player ";
                break;
            }
            case OPPONENT: {
                text = text + "an opponent ";
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong code usage. targetController not yet supported: " + (Object)((Object)this.targetController));
            }
        }
        return text + "mills a " + this.filter.getMessage() + ", ";
    }
}

