/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCosts;
import mage.cards.Card;
import mage.constants.SpellAbilityType;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.util.CardUtil;

public class PayMoreToCastAsThoughtItHadFlashAbility
extends SpellAbility {
    private final Cost costsToAdd;
    private final String rule;

    public PayMoreToCastAsThoughtItHadFlashAbility(Card card, Cost costsToAdd) {
        this(card, costsToAdd, null);
    }

    public PayMoreToCastAsThoughtItHadFlashAbility(Card card, Cost costsToAdd, String rule) {
        super(card.getSpellAbility().getManaCosts().copy(), card.getName(), Zone.HAND, SpellAbilityType.BASE_ALTERNATE);
        this.costsToAdd = costsToAdd;
        this.rule = rule;
        this.timing = TimingRule.INSTANT;
        this.setRuleAtTheTop(true);
        if (costsToAdd instanceof ManaCosts) {
            ManaCosts manaCosts = (ManaCosts)costsToAdd;
            CardUtil.increaseCost(this, manaCosts);
        } else {
            this.addCost(costsToAdd);
        }
    }

    protected PayMoreToCastAsThoughtItHadFlashAbility(PayMoreToCastAsThoughtItHadFlashAbility ability) {
        super(ability);
        this.rule = ability.rule;
        this.costsToAdd = ability.costsToAdd;
    }

    @Override
    public PayMoreToCastAsThoughtItHadFlashAbility copy() {
        return new PayMoreToCastAsThoughtItHadFlashAbility(this);
    }

    @Override
    public String getRule(boolean all) {
        return this.getRule();
    }

    @Override
    public String getRule() {
        if (this.rule != null && !this.rule.isEmpty()) {
            return this.rule;
        }
        if (this.costsToAdd instanceof ManaCosts) {
            return "You may cast this spell as though it had flash if you pay " + this.costsToAdd.getText() + " more to cast it. <i>(You may cast it any time you could cast an instant.)</i>";
        }
        return "You may cast this spell as though it had flash by " + this.costsToAdd.getText() + " in addition to paying its other costs.";
    }
}

