/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

public class PlayCardTriggeredAbility
extends TriggeredAbilityImpl {
    private final TargetController targetController;

    public PlayCardTriggeredAbility(TargetController targetController, Zone zone, Effect effect) {
        this(targetController, zone, effect, false);
    }

    public PlayCardTriggeredAbility(TargetController targetController, Zone zone, Effect effect, boolean optional) {
        super(zone, effect, optional);
        this.targetController = targetController;
        this.constructTriggerPhrase();
    }

    private void constructTriggerPhrase() {
        switch (this.targetController) {
            case ANY: {
                this.setTriggerPhrase("Whenever a player plays play a card, ");
                break;
            }
            case NOT_YOU: {
                this.setTriggerPhrase("Whenever another player plays a card, ");
                break;
            }
            case OPPONENT: {
                this.setTriggerPhrase("Whenever an opponent plays a card, ");
                break;
            }
            case YOU: {
                this.setTriggerPhrase("Whenever you play a card, ");
                break;
            }
            default: {
                throw new UnsupportedOperationException("TargetController not supported");
            }
        }
    }

    protected PlayCardTriggeredAbility(PlayCardTriggeredAbility ability) {
        super(ability);
        this.targetController = ability.targetController;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.LAND_PLAYED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        boolean playerMatches;
        switch (this.targetController) {
            case ANY: {
                playerMatches = true;
                break;
            }
            case NOT_YOU: {
                playerMatches = !this.isControlledBy(event.getPlayerId());
                break;
            }
            case OPPONENT: {
                playerMatches = game.getPlayer(this.getControllerId()).hasOpponent(event.getPlayerId(), game);
                break;
            }
            case YOU: {
                playerMatches = this.isControlledBy(event.getPlayerId());
                break;
            }
            default: {
                throw new UnsupportedOperationException("TargetController not supported");
            }
        }
        return playerMatches && (event.getType() != GameEvent.EventType.SPELL_CAST || !game.getSpell(event.getTargetId()).getCard().isCopy());
    }

    @Override
    public PlayCardTriggeredAbility copy() {
        return new PlayCardTriggeredAbility(this);
    }
}

