/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;

public class PlayerAttacksTriggeredAbility
extends TriggeredAbilityImpl {
    private final boolean setTarget;

    public PlayerAttacksTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public PlayerAttacksTriggeredAbility(Effect effect, boolean setTarget) {
        this(Zone.BATTLEFIELD, effect, setTarget, false);
    }

    public PlayerAttacksTriggeredAbility(Zone zone, Effect effect, boolean setTarget, boolean optional) {
        super(zone, effect, optional);
        this.setTarget = setTarget;
        this.setTriggerPhrase(this.generateTriggerPhrase());
    }

    private PlayerAttacksTriggeredAbility(PlayerAttacksTriggeredAbility ability) {
        super(ability);
        this.setTarget = ability.setTarget;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getCombat().getAttackers().isEmpty()) {
            if (this.setTarget) {
                this.getEffects().setTargetPointer(new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    private String generateTriggerPhrase() {
        return "Whenever a player attacks, ";
    }

    @Override
    public PlayerAttacksTriggeredAbility copy() {
        return new PlayerAttacksTriggeredAbility(this);
    }
}

