/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class PutCounterOnPermanentTriggeredAbility
extends TriggeredAbilityImpl {
    private final CounterType counterType;
    private final FilterPermanent filter;
    private final boolean setTargetPointer;

    public PutCounterOnPermanentTriggeredAbility(Effect effect, CounterType counterType, FilterPermanent filter) {
        this(effect, counterType, filter, false, false);
    }

    public PutCounterOnPermanentTriggeredAbility(Effect effect, CounterType counterType, FilterPermanent filter, boolean setTargetPointer, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.counterType = counterType;
        this.filter = filter;
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase("Whenever you put one or more " + (this.counterType == null ? "" : this.counterType.getName() + " ") + "counters on " + CardUtil.addArticle(filter.getMessage()) + ", ");
    }

    protected PutCounterOnPermanentTriggeredAbility(PutCounterOnPermanentTriggeredAbility ability) {
        super(ability);
        this.counterType = ability.counterType;
        this.filter = ability.filter;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public PutCounterOnPermanentTriggeredAbility copy() {
        return new PutCounterOnPermanentTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent == null) {
            permanent = game.getPermanentEntering(event.getTargetId());
        }
        if (permanent == null || !this.filter.match(permanent, this.controllerId, (Ability)this, game)) {
            return false;
        }
        if (this.counterType != null && !event.getData().equals(this.counterType.getName())) {
            return false;
        }
        if (this.setTargetPointer) {
            this.getEffects().setTargetPointer(new FixedTarget(event.getTargetId(), game));
        }
        this.getEffects().setValue("countersAdded", event.getAmount());
        return true;
    }
}

