/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

public class SignatureSpellCastOnlyWithOathbreakerEffect
extends ContinuousRuleModifyingEffectImpl {
    private final Condition condition;
    private final UUID signatureSpell;

    public SignatureSpellCastOnlyWithOathbreakerEffect(Condition condition, UUID signatureSpell) {
        super(Duration.EndOfGame, Outcome.Detriment);
        this.condition = condition;
        this.signatureSpell = signatureSpell;
        this.staticText = this.setText();
    }

    private SignatureSpellCastOnlyWithOathbreakerEffect(SignatureSpellCastOnlyWithOathbreakerEffect effect) {
        super(effect);
        this.condition = effect.condition;
        this.signatureSpell = effect.signatureSpell;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getSourceId().equals(this.signatureSpell)) {
            return this.condition != null && !this.condition.apply(game, source);
        }
        return false;
    }

    @Override
    public SignatureSpellCastOnlyWithOathbreakerEffect copy() {
        return new SignatureSpellCastOnlyWithOathbreakerEffect(this);
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("cast this spell only ");
        if (this.condition != null) {
            sb.append(' ').append(this.condition.toString());
        }
        return sb.toString();
    }
}

