/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

public class SourceDealsDamageToYouTriggeredAbility
extends TriggeredAbilityImpl {
    private final FilterPermanent filter;

    public SourceDealsDamageToYouTriggeredAbility(Effect effect, boolean optional) {
        this(effect, null, optional);
    }

    public SourceDealsDamageToYouTriggeredAbility(Effect effect, FilterPermanent filter, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.filter = filter;
        if (filter != null) {
            this.setTriggerPhrase("Whenever a source an opponent controls deals damage to you or a " + filter.getMessage() + " you control, ");
        } else {
            this.setTriggerPhrase("Whenever a source an opponent controls deals damage to you, ");
        }
    }

    protected SourceDealsDamageToYouTriggeredAbility(SourceDealsDamageToYouTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
    }

    @Override
    public SourceDealsDamageToYouTriggeredAbility copy() {
        return new SourceDealsDamageToYouTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGED_PLAYER: 
            case DAMAGED_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        int damageAmount;
        UUID sourceControllerId = game.getControllerId(event.getSourceId());
        if (sourceControllerId == null || !game.getOpponents(this.getControllerId()).contains(sourceControllerId)) {
            return false;
        }
        switch (event.getType()) {
            case DAMAGED_PLAYER: {
                if (event.getTargetId().equals(this.getControllerId())) break;
                return false;
            }
            case DAMAGED_PERMANENT: {
                if (this.filter == null) {
                    return false;
                }
                Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
                if (permanent == null || !permanent.isControlledBy(this.getControllerId())) {
                    return false;
                }
                if (this.filter.match(permanent, this.getControllerId(), (Ability)this, game)) break;
                return false;
            }
            default: {
                return false;
            }
        }
        if ((damageAmount = event.getAmount()) < 1) {
            return false;
        }
        this.getAllEffects().setValue("damage", damageAmount);
        this.getAllEffects().setTargetPointer(new FixedTarget(sourceControllerId));
        return true;
    }
}

