/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TurnFaceUpEffect
extends OneShotEffect {
    private final boolean megamorph;

    public TurnFaceUpEffect(boolean megamorph) {
        super(Outcome.Benefit);
        this.staticText = "Turn this face-down permanent face up" + (megamorph ? " and put a +1/+1 counter on it" : "");
        this.megamorph = megamorph;
    }

    protected TurnFaceUpEffect(TurnFaceUpEffect effect) {
        super(effect);
        this.megamorph = effect.megamorph;
    }

    @Override
    public TurnFaceUpEffect copy() {
        return new TurnFaceUpEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent;
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (controller != null && card != null && (sourcePermanent = game.getPermanent(source.getSourceId())) != null && sourcePermanent.turnFaceUp(source, game, source.getControllerId())) {
            if (this.megamorph) {
                sourcePermanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
            }
            game.getState().setValue(source.getSourceId().toString() + "TurnFaceUpX", CardUtil.getSourceCostsTag(game, source, "X", 0));
            return true;
        }
        return false;
    }
}

