/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

public class TurnedFaceUpAllTriggeredAbility
extends TriggeredAbilityImpl {
    private FilterPermanent filter;
    private boolean setTargetPointer;

    public TurnedFaceUpAllTriggeredAbility(Effect effect, FilterPermanent filter) {
        this(effect, filter, false);
    }

    public TurnedFaceUpAllTriggeredAbility(Effect effect, FilterPermanent filter, boolean setTargetPointer) {
        this(Zone.BATTLEFIELD, effect, filter, setTargetPointer, false);
    }

    public TurnedFaceUpAllTriggeredAbility(Zone zone, Effect effect, FilterPermanent filter, boolean setTargetPointer, boolean optional) {
        super(zone, effect, optional);
        this.setWorksFaceDown(true);
        this.filter = filter;
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase("Whenever " + filter.getMessage() + " is turned face up, ");
    }

    protected TurnedFaceUpAllTriggeredAbility(TurnedFaceUpAllTriggeredAbility ability) {
        super(ability);
        this.setTargetPointer = ability.setTargetPointer;
        this.filter = ability.filter;
    }

    @Override
    public TurnedFaceUpAllTriggeredAbility copy() {
        return new TurnedFaceUpAllTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TURNED_FACE_UP;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (!event.getTargetId().equals(this.getSourceId())) {
            MageObject sourceObj = this.getSourceObject(game);
            if (sourceObj != null) {
                if (sourceObj instanceof Card && ((Card)sourceObj).isFaceDown(game)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.filter.match(permanent = game.getPermanent(event.getTargetId()), this.getControllerId(), (Ability)this, game)) {
            if (this.setTargetPointer) {
                for (Effect effect : this.getEffects()) {
                    effect.setTargetPointer(new FixedTarget(event.getTargetId(), game));
                }
            }
            return true;
        }
        return false;
    }
}

