/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common.delayed;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

public class AtTheBeginOfStepOfYourNextTurnDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private GameEvent.EventType stepEvent;
    private int nextTurn = -1;
    private boolean isActive = true;

    public AtTheBeginOfStepOfYourNextTurnDelayedTriggeredAbility(Effect effect, GameEvent.EventType stepEvent) {
        this(effect, stepEvent, false);
    }

    public AtTheBeginOfStepOfYourNextTurnDelayedTriggeredAbility(Effect effect, GameEvent.EventType stepEvent, boolean optional) {
        super(effect, Duration.Custom, true, optional);
        this.stepEvent = stepEvent;
        this.setTriggerPhrase(this.generateTriggerPhrase());
    }

    private AtTheBeginOfStepOfYourNextTurnDelayedTriggeredAbility(AtTheBeginOfStepOfYourNextTurnDelayedTriggeredAbility ability) {
        super(ability);
        this.nextTurn = ability.nextTurn;
        this.isActive = ability.isActive;
        this.stepEvent = ability.stepEvent;
    }

    @Override
    public AtTheBeginOfStepOfYourNextTurnDelayedTriggeredAbility copy() {
        return new AtTheBeginOfStepOfYourNextTurnDelayedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == this.stepEvent || event.getType() == GameEvent.EventType.BEGIN_TURN;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        int turn = game.getTurnNum();
        switch (event.getType()) {
            case BEGIN_TURN: {
                if (this.nextTurn == -1) {
                    this.nextTurn = turn;
                } else if (turn > this.nextTurn) {
                    this.isActive = false;
                }
                return false;
            }
        }
        return turn == this.nextTurn && event.getType() == this.stepEvent;
    }

    @Override
    public boolean isInactive(Game game) {
        return super.isInactive(game) || !this.isActive;
    }

    private String generateTriggerPhrase() {
        switch (this.stepEvent) {
            case END_TURN_STEP_PRE: {
                return "At the beginning of the end step on your next turn, ";
            }
            case DECLARE_ATTACKERS_STEP_PRE: {
                return "At the beginning of the declare attackers step on your next turn, ";
            }
        }
        throw new IllegalArgumentException("stepEvent only supports steps events");
    }
}

