/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common.delayed;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ReturnExiledPermanentsEffect
extends OneShotEffect {
    private final Zone zone;

    ReturnExiledPermanentsEffect(Zone zone) {
        super(Outcome.Benefit);
        this.zone = zone;
        this.staticText = "Return exiled permanents";
    }

    protected ReturnExiledPermanentsEffect(ReturnExiledPermanentsEffect effect) {
        super(effect);
        this.zone = effect.zone;
    }

    @Override
    public ReturnExiledPermanentsEffect copy() {
        return new ReturnExiledPermanentsEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        ExileZone exile;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null && controller != null && (exile = this.getExileIfPossible(game, source)) != null) {
            return controller.moveCards(new LinkedHashSet<Card>(exile.getCards(game)), this.zone, source, game, false, false, true, null);
        }
        return false;
    }

    private ExileZone getExileIfPossible(Game game, Ability source) {
        UUID exileZone = CardUtil.getExileZoneId(game, source.getSourceId(), source.getStackMomentSourceZCC());
        if (exileZone != null) {
            ExileZone exile = game.getExile().getExileZone(exileZone);
            if (exile == null && (exileZone = CardUtil.getCardExileZoneId(game, source)) != null) {
                return game.getExile().getExileZone(exileZone);
            }
            return exile;
        }
        return null;
    }
}

