/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common.delayed;

import java.util.ArrayList;
import java.util.List;
import mage.MageObject;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.Modes;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.hint.Hint;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

public class UntilYourNextTurnDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final TriggeredAbility ability;

    public UntilYourNextTurnDelayedTriggeredAbility(TriggeredAbility ability) {
        super(null, Duration.UntilYourNextTurn, false);
        if (ability.isLeavesTheBattlefieldTrigger()) {
            this.setLeavesTheBattlefieldTrigger(true);
        }
        this.ability = ability;
    }

    protected UntilYourNextTurnDelayedTriggeredAbility(UntilYourNextTurnDelayedTriggeredAbility triggeredAbility) {
        super(triggeredAbility);
        this.ability = triggeredAbility.ability.copy();
    }

    @Override
    public UntilYourNextTurnDelayedTriggeredAbility copy() {
        return new UntilYourNextTurnDelayedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return this.ability.checkEventType(event, game);
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        this.ability.setSourceId(this.getSourceId());
        this.ability.setControllerId(this.getControllerId());
        return this.ability.checkTrigger(event, game);
    }

    @Override
    public String getRule() {
        return "Until your next turn, " + CardUtil.getTextWithFirstCharLowerCase(this.ability.getRule());
    }

    @Override
    public Effects getEffects() {
        return this.ability.getEffects();
    }

    @Override
    public void addEffect(Effect effect) {
        this.ability.addEffect(effect);
    }

    @Override
    public Modes getModes() {
        return this.ability.getModes();
    }

    @Override
    public List<Watcher> getWatchers() {
        return this.ability.getWatchers();
    }

    @Override
    public void addWatcher(Watcher watcher) {
        this.ability.addWatcher(watcher);
    }

    @Override
    public List<Hint> getHints() {
        ArrayList<Hint> res = new ArrayList<Hint>(super.getHints());
        res.addAll(this.ability.getHints());
        return res;
    }

    @Override
    public Effects getEffects(Game game, EffectType effectType) {
        return this.ability.getEffects(game, effectType);
    }

    @Override
    public boolean isOptional() {
        return this.ability.isOptional();
    }

    @Override
    public void setSourceObjectZoneChangeCounter(int sourceObjectZoneChangeCounter) {
        this.ability.setSourceObjectZoneChangeCounter(sourceObjectZoneChangeCounter);
    }

    @Override
    public int getStackMomentSourceZCC() {
        return this.ability.getStackMomentSourceZCC();
    }

    @Override
    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        if (this.isLeavesTheBattlefieldTrigger()) {
            return TriggeredAbilityImpl.isInUseableZoneDiesTrigger(this, sourceObject, event, game);
        }
        return super.isInUseableZone(game, sourceObject, event);
    }
}

