/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.AttackedOrBlockedThisCombatWatcher;

public enum AttackedOrBlockedThisCombatSourceCondition implements Condition
{
    instance;


    @Override
    public boolean apply(Game game, Ability source) {
        AttackedOrBlockedThisCombatWatcher watcher;
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourceObject != null && (watcher = game.getState().getWatcher(AttackedOrBlockedThisCombatWatcher.class)) != null) {
            for (MageObjectReference mor : watcher.getAttackedThisTurnCreatures()) {
                if (!mor.refersTo(sourceObject, game)) continue;
                return true;
            }
            for (MageObjectReference mor : watcher.getBlockedThisTurnCreatures()) {
                if (!mor.refersTo(sourceObject, game)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "{this} attacked or blocked this combat";
    }
}

