/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.TargetController;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;

public class CreatureCountCondition
implements Condition {
    private FilterCreaturePermanent filter;
    private int creatureCount;
    private TargetController targetController;

    public CreatureCountCondition(FilterCreaturePermanent filter, int creatureCount, TargetController targetController) {
        this.filter = filter;
        this.creatureCount = creatureCount;
        this.targetController = targetController;
    }

    public CreatureCountCondition(int creatureCount, TargetController targetController) {
        this.filter = new FilterCreaturePermanent();
        this.creatureCount = creatureCount;
        this.targetController = targetController;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        switch (this.targetController) {
            case YOU: {
                return game.getBattlefield().countAll(this.filter, source.getControllerId(), game) == this.creatureCount;
            }
            case OPPONENT: {
                for (UUID opponent : game.getOpponents(source.getControllerId())) {
                    if (game.getBattlefield().countAll(this.filter, opponent, game) == this.creatureCount) continue;
                    return false;
                }
                return true;
            }
            case ANY: {
                return game.getBattlefield().count(this.filter, source.getControllerId(), source, game) == this.creatureCount;
            }
        }
        throw new UnsupportedOperationException("Value for targetController not supported: " + this.targetController.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.targetController) {
            case YOU: {
                sb.append("you");
                break;
            }
            case OPPONENT: {
                sb.append("your opponents");
                break;
            }
            case ANY: {
                sb.append("if ");
                sb.append(this.creatureCount);
                sb.append(' ');
                sb.append(this.filter.getMessage());
                sb.append(" are on the battlefield");
                return sb.toString();
            }
        }
        sb.append(" control");
        if (this.creatureCount == 0) {
            sb.append(" no ");
        } else {
            sb.append(" exactly ");
            sb.append(this.creatureCount);
            sb.append(' ');
        }
        sb.append(this.filter.getMessage());
        sb.append(this.creatureCount != 1 ? "s" : "");
        return sb.toString();
    }
}

