/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.ComparisonType;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class EnchantedSourceCondition
implements Condition {
    private int numberOfEnchantments;
    private ComparisonType comparisonType;
    private boolean aurasOnly;

    public EnchantedSourceCondition() {
        this(1);
    }

    public EnchantedSourceCondition(int numberOfEnchantments) {
        this(numberOfEnchantments, ComparisonType.OR_GREATER, false);
    }

    public EnchantedSourceCondition(int numberOfEnchantments, ComparisonType comparisonType, boolean aurasOnly) {
        this.numberOfEnchantments = numberOfEnchantments;
        this.comparisonType = comparisonType;
        this.aurasOnly = aurasOnly;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        int numberOfFoundEnchantments = 0;
        if (permanent != null) {
            for (UUID uuid : permanent.getAttachments()) {
                Permanent attached = game.getPermanent(uuid);
                if (attached == null || !attached.isEnchantment(game) || this.aurasOnly && !attached.hasSubtype(SubType.AURA, game)) continue;
                ++numberOfFoundEnchantments;
            }
        }
        return ComparisonType.compare(numberOfFoundEnchantments, this.comparisonType, this.numberOfEnchantments);
    }

    public String toString() {
        return "{this} is enchanted" + (this.numberOfEnchantments > 1 ? " by " + CardUtil.numberToText(this.numberOfEnchantments) + " or more Auras" : "");
    }
}

