/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.ArrayList;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class EquippedHasSubtypeCondition
implements Condition {
    private final List<SubType> subTypes = new ArrayList<SubType>();

    public EquippedHasSubtypeCondition(SubType ... subTypes) {
        for (SubType subType : subTypes) {
            this.subTypes.add(subType);
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null || permanent.getAttachedTo() == null) {
            return false;
        }
        Permanent attachedTo = game.getPermanent(permanent.getAttachedTo());
        if (attachedTo == null) {
            attachedTo = (Permanent)game.getLastKnownInformation(permanent.getAttachedTo(), Zone.BATTLEFIELD);
        }
        if (attachedTo == null) {
            return false;
        }
        for (SubType s : this.subTypes) {
            if (!attachedTo.hasSubtype(s, game)) continue;
            return true;
        }
        return false;
    }
}

