/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.cards.Card;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SpellOptionCard;
import mage.cards.SplitCardHalf;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;

public enum IsBeingCastFromHandCondition implements Condition
{
    instance;


    @Override
    public boolean apply(Game game, Ability source) {
        MageObject object = game.getObject(source);
        if (object instanceof SplitCardHalf || object instanceof SpellOptionCard || object instanceof ModalDoubleFacedCardHalf) {
            UUID mainCardId = ((Card)object).getMainCard().getId();
            object = game.getObject(mainCardId);
        }
        if (object instanceof Spell) {
            Spell spell = (Spell)object;
            return Zone.HAND.equals((Object)spell.getFromZone());
        }
        if (object instanceof Card) {
            Card card = (Card)object;
            return game.getPlayer(card.getOwnerId()).getHand().get(card.getId(), game) != null;
        }
        return false;
    }
}

