/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.Objects;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.ComparisonType;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;

public class LifeCompareCondition
implements Condition {
    private final TargetController targetController;
    private final ComparisonType comparisonType;
    private final int amount;

    public LifeCompareCondition(TargetController targetController, ComparisonType comparisonType, int amount) {
        this.targetController = targetController;
        this.comparisonType = comparisonType;
        this.amount = amount;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        switch (this.targetController) {
            case YOU: {
                return ComparisonType.compare(controller.getLife(), this.comparisonType, this.amount);
            }
            case OPPONENT: {
                return game.getOpponents(controller.getId()).stream().map(game::getPlayer).filter(Objects::nonNull).filter(Player::isInGame).map(Player::getLife).anyMatch(l -> ComparisonType.compare(l, this.comparisonType, this.amount));
            }
            case ANY: {
                return game.getState().getPlayersInRange(controller.getId(), game).stream().map(game::getPlayer).filter(Objects::nonNull).filter(Player::isInGame).map(Player::getLife).anyMatch(l -> ComparisonType.compare(l, this.comparisonType, this.amount));
            }
            case EACH_PLAYER: {
                return game.getState().getPlayersInRange(controller.getId(), game).stream().map(game::getPlayer).filter(Objects::nonNull).filter(Player::isInGame).map(Player::getLife).allMatch(l -> ComparisonType.compare(l, this.comparisonType, this.amount));
            }
            case ACTIVE: {
                return Optional.ofNullable(game).map(Game::getActivePlayerId).map(game::getPlayer).map(Player::getLife).filter(l -> ComparisonType.compare(l, this.comparisonType, this.amount)).isPresent();
            }
        }
        throw new IllegalArgumentException("Unsupported TargetController in LifeCompareCondition: " + (Object)((Object)this.targetController));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.targetController) {
            case YOU: {
                sb.append("you have ");
                break;
            }
            case OPPONENT: {
                sb.append("an opponent has ");
                break;
            }
            case ANY: {
                sb.append("a player has ");
                break;
            }
            case EACH_PLAYER: {
                sb.append("each player has ");
                break;
            }
            case ACTIVE: {
                sb.append("that player has ");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported TargetController in LifeCompareCondition: " + (Object)((Object)this.targetController));
            }
        }
        switch (this.comparisonType) {
            case MORE_THAN: {
                sb.append("more than ").append(this.amount);
                break;
            }
            case FEWER_THAN: {
                sb.append("less than ").append(this.amount);
                break;
            }
            case EQUAL_TO: {
                sb.append("exactly ").append(this.amount);
                break;
            }
            case OR_GREATER: {
                sb.append(this.amount).append(" or more");
                break;
            }
            case OR_LESS: {
                sb.append(this.amount).append(" or less");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ComparisonType in LifeCompareCondition: " + (Object)((Object)this.comparisonType));
            }
        }
        sb.append(" life");
        return sb.toString();
    }
}

