/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;

public class OpponentControlsPermanentCondition
implements Condition {
    private FilterPermanent filter;
    private ComparisonType type;
    private int count;

    public OpponentControlsPermanentCondition(FilterPermanent filter) {
        this(filter, ComparisonType.MORE_THAN, 0);
    }

    public OpponentControlsPermanentCondition(FilterPermanent filter, ComparisonType type, int count) {
        this.filter = filter;
        this.type = type;
        this.count = count;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        boolean conditionApplies = false;
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            FilterPermanent localFilter = this.filter.copy();
            localFilter.add(new ControllerIdPredicate(opponentId));
            if (!ComparisonType.compare(game.getBattlefield().count(localFilter, source.getControllerId(), source, game), this.type, this.count)) continue;
            conditionApplies = true;
            break;
        }
        return conditionApplies;
    }

    public String toString() {
        return this.filter.getMessage();
    }
}

