/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public class ExileSourceCost
extends CostImpl {
    public ExileSourceCost() {
        this.text = "exile {this}";
    }

    public ExileSourceCost(ExileSourceCost cost) {
        super(cost);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        MageObject sourceObject = ability.getSourceObject(game);
        Player controller = game.getPlayer(controllerId);
        if (controller == null || !(sourceObject instanceof Card)) {
            return this.paid;
        }
        controller.moveCards((Card)sourceObject, Zone.EXILED, source, game);
        this.paid = true;
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return source.getSourceCardIfItStillExists(game) != null;
    }

    @Override
    public ExileSourceCost copy() {
        return new ExileSourceCost(this);
    }
}

