/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.game.Game;
import mage.players.Player;

public class GainLifePlayersCost
extends CostImpl {
    private final int amount;

    public GainLifePlayersCost(int amount) {
        this.amount = amount;
        this.text = "you may have each other player gain " + amount + " life";
    }

    public GainLifePlayersCost(GainLifePlayersCost cost) {
        super(cost);
        this.amount = cost.amount;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                if (playerId.equals(controllerId) || (player = game.getPlayer(playerId)) == null || player.isCanGainLife()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                if (playerId.equals(controllerId) || (player = game.getPlayer(playerId)) == null) continue;
                player.gainLife(this.amount, game, source);
            }
            this.paid = true;
        }
        return this.paid;
    }

    @Override
    public GainLifePlayersCost copy() {
        return new GainLifePlayersCost(this);
    }
}

