/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.SacrificeCost;
import mage.abilities.costs.UseAttachedCost;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class SacrificeAttachmentCost
extends UseAttachedCost
implements SacrificeCost {
    public SacrificeAttachmentCost() {
    }

    protected SacrificeAttachmentCost(SacrificeAttachmentCost cost) {
        super(cost);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (this.mageObjectReference == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return this.paid;
        }
        for (UUID attachmentId : permanent.getAttachments()) {
            if (!this.mageObjectReference.refersTo(attachmentId, game)) continue;
            Permanent attachment = game.getPermanent(attachmentId);
            boolean bl = this.paid = attachment != null && attachment.isControlledBy(controllerId) && attachment.sacrifice(source, game);
            if (!this.paid) continue;
            break;
        }
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        if (!super.canPay(ability, source, controllerId, game)) {
            return false;
        }
        Player controller = game.getPlayer(controllerId);
        Permanent permanent = this.mageObjectReference.getPermanent(game);
        if (controller == null || permanent == null) {
            return false;
        }
        return controller.canPaySacrificeCost(permanent, source, controllerId, game);
    }

    @Override
    public SacrificeAttachmentCost copy() {
        return new SacrificeAttachmentCost(this);
    }

    @Override
    public String getText() {
        return "sacrifice " + this.name;
    }
}

