/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.costs.SacrificeCost;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetSacrifice;
import mage.util.CardUtil;

public class SacrificeTargetCost
extends CostImpl
implements SacrificeCost {
    private final List<Permanent> permanents = new ArrayList<Permanent>();

    public SacrificeTargetCost(FilterPermanent filter) {
        this(1, filter);
    }

    public SacrificeTargetCost(int numToSac, FilterPermanent filter) {
        this(new TargetSacrifice(numToSac, filter));
    }

    public SacrificeTargetCost(TargetSacrifice target) {
        this.addTarget(target);
        target.setRequired(false);
        this.text = "sacrifice " + SacrificeTargetCost.makeText(target);
    }

    public SacrificeTargetCost(SacrificeTargetCost cost) {
        super(cost);
        for (Permanent permanent : cost.permanents) {
            this.permanents.add(permanent.copy());
        }
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (this.getTargets().choose(Outcome.Sacrifice, controllerId, source.getSourceId(), source, game)) {
            for (UUID targetId : ((Target)this.getTargets().get(0)).getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) {
                    return false;
                }
                this.addSacrificeTarget(game, permanent);
                this.paid |= permanent.sacrifice(source, game);
            }
            if (!this.paid && ((Target)this.getTargets().get(0)).getMinNumberOfTargets() == 0) {
                this.paid = true;
            }
        }
        return this.paid;
    }

    protected void addSacrificeTarget(Game game, Permanent permanent) {
        this.permanents.add(permanent.copy());
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        int validTargets = 0;
        int neededTargets = ((Target)this.getTargets().get(0)).getMinNumberOfTargets();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(((TargetPermanent)this.getTargets().get(0)).getFilter(), controllerId, source, game)) {
            if (!controller.canPaySacrificeCost(permanent, source, controllerId, game) || ++validTargets < neededTargets) continue;
            return true;
        }
        return validTargets == 0 && ((Target)this.getTargets().get(0)).getMinNumberOfTargets() == 0;
    }

    @Override
    public SacrificeTargetCost copy() {
        return new SacrificeTargetCost(this);
    }

    public List<Permanent> getPermanents() {
        return this.permanents;
    }

    private static String makeText(TargetSacrifice target) {
        if (target.getMinNumberOfTargets() != target.getMaxNumberOfTargets()) {
            return target.getTargetName();
        }
        if (target.getMinNumberOfTargets() == 1 || target.getTargetName().startsWith("a ") || target.getTargetName().startsWith("an ")) {
            return CardUtil.addArticle(target.getTargetName());
        }
        return CardUtil.numberToText(target.getMinNumberOfTargets()) + ' ' + target.getTargetName();
    }
}

