/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.TapTargetCost;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.target.common.TargetControlledPermanent;

public class TapVariableTargetCost
extends VariableCostImpl {
    protected FilterControlledPermanent filter;

    public TapVariableTargetCost(FilterControlledPermanent filter) {
        this(filter, false, "X");
    }

    public TapVariableTargetCost(FilterControlledPermanent filter, boolean useAsAdditionalCost, String xText) {
        super(useAsAdditionalCost ? VariableCostType.ADDITIONAL : VariableCostType.NORMAL, xText, filter.getMessage() + " to tap");
        this.filter = filter;
        this.text = (useAsAdditionalCost ? "as an additional cost to cast this spell, tap " : "Tap ") + this.xText + ' ' + filter.getMessage();
    }

    protected TapVariableTargetCost(TapVariableTargetCost cost) {
        super(cost);
        this.filter = cost.filter.copy();
    }

    @Override
    public TapVariableTargetCost copy() {
        return new TapVariableTargetCost(this);
    }

    @Override
    public int getMaxValue(Ability source, Game game) {
        return game.getBattlefield().count(this.filter, source.getControllerId(), source, game);
    }

    @Override
    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        return new TapTargetCost(new TargetControlledPermanent(xValue, xValue, this.filter, true));
    }
}

