/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.decorator;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.condition.FixedCondition;
import mage.abilities.condition.LockedInCondition;
import mage.abilities.effects.ReplacementEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

public class ConditionalReplacementEffect
extends ReplacementEffectImpl {
    protected ReplacementEffect effect;
    protected ReplacementEffect otherwiseEffect;
    protected Condition baseCondition;
    protected Condition condition;
    protected boolean conditionState;
    protected boolean initDone = false;

    public ConditionalReplacementEffect(ReplacementEffect effect, Condition condition) {
        this(effect, condition, null);
    }

    public ConditionalReplacementEffect(ReplacementEffect effect, Condition condition, ReplacementEffect otherwiseEffect) {
        super(effect.getDuration(), effect.getOutcome());
        this.effect = effect;
        this.baseCondition = condition;
        this.otherwiseEffect = otherwiseEffect;
    }

    protected ConditionalReplacementEffect(ConditionalReplacementEffect effect) {
        super(effect);
        this.effect = effect.effect.copy();
        if (effect.otherwiseEffect != null) {
            this.otherwiseEffect = effect.otherwiseEffect.copy();
        }
        this.condition = effect.condition;
        this.conditionState = effect.conditionState;
        this.baseCondition = effect.baseCondition;
        this.initDone = effect.initDone;
    }

    @Override
    public boolean isDiscarded() {
        return this.effect.isDiscarded() || this.otherwiseEffect != null && this.otherwiseEffect.isDiscarded();
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        this.condition = this.baseCondition instanceof LockedInCondition ? new FixedCondition(((LockedInCondition)this.baseCondition).getBaseCondition().apply(game, source)) : this.baseCondition;
        this.effect.setTargetPointer(this.getTargetPointer().copy());
        this.effect.init(source, game);
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            this.otherwiseEffect.init(source, game);
        }
        this.initDone = true;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (this.conditionState) {
            this.effect.setTargetPointer(this.getTargetPointer().copy());
            return this.effect.replaceEvent(event, source, game);
        }
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            return this.otherwiseEffect.replaceEvent(event, source, game);
        }
        if (!this.conditionState && this.effect.getDuration() == Duration.OneUse) {
            this.used = true;
        }
        if (!this.conditionState && this.effect.getDuration() == Duration.Custom) {
            this.discard();
        }
        return true;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return this.effect.checksEventType(event, game) || this.otherwiseEffect != null && this.otherwiseEffect.checksEventType(event, game);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.initDone) {
            this.init(source, game);
        }
        this.conditionState = this.condition.apply(game, source);
        if (this.conditionState) {
            this.effect.setTargetPointer(this.getTargetPointer().copy());
            return this.effect.applies(event, source, game);
        }
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            return this.otherwiseEffect.applies(event, source, game);
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText == null || this.staticText.isEmpty() && this.effect != null) {
            return this.effect.getText(mode);
        }
        return this.staticText;
    }

    @Override
    public ConditionalReplacementEffect copy() {
        return new ConditionalReplacementEffect(this);
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }
}

