/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;

public class MultipliedValue
implements DynamicValue {
    private final DynamicValue value;
    private final int multiplier;

    public MultipliedValue(DynamicValue value, int multiplier) {
        this.value = value.copy();
        this.multiplier = multiplier;
    }

    MultipliedValue(MultipliedValue dynamicValue) {
        this.value = dynamicValue.value.copy();
        this.multiplier = dynamicValue.multiplier;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return this.multiplier * this.value.calculate(game, sourceAbility, effect);
    }

    @Override
    public MultipliedValue copy() {
        return new MultipliedValue(this);
    }

    public String toString() {
        if (this.value.toString().equals("1")) {
            return Integer.toString(this.multiplier);
        }
        StringBuilder sb = new StringBuilder();
        if (this.multiplier == 2) {
            sb.append("twice ");
        } else {
            sb.append(this.multiplier).append(" * ");
        }
        return sb.append(this.value.toString()).toString();
    }

    @Override
    public String getMessage() {
        return this.value.getMessage();
    }

    @Override
    public int getSign() {
        return this.multiplier * this.value.getSign();
    }
}

