/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import java.io.ObjectStreamException;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;

public class ColorsOfManaSpentToCastCount
implements DynamicValue {
    private static final ColorsOfManaSpentToCastCount instance = new ColorsOfManaSpentToCastCount();

    private Object readResolve() throws ObjectStreamException {
        return instance;
    }

    public static ColorsOfManaSpentToCastCount getInstance() {
        return instance;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        MageObject mageObject;
        int count = 0;
        Spell spell = game.getStack().getSpell(sourceAbility.getSourceId());
        if (spell == null && (mageObject = game.getLastKnownInformation(sourceAbility.getSourceId(), Zone.STACK)) instanceof Spell) {
            spell = (Spell)mageObject;
        }
        if (spell != null) {
            Mana mana = spell.getSpellAbility().getManaCostsToPay().getUsedManaToPay();
            if (mana.getBlack() > 0) {
                ++count;
            }
            if (mana.getBlue() > 0) {
                ++count;
            }
            if (mana.getGreen() > 0) {
                ++count;
            }
            if (mana.getRed() > 0) {
                ++count;
            }
            if (mana.getWhite() > 0) {
                ++count;
            }
        }
        return count;
    }

    @Override
    public ColorsOfManaSpentToCastCount copy() {
        return new ColorsOfManaSpentToCastCount();
    }

    public String toString() {
        return "X";
    }

    @Override
    public String getMessage() {
        return "the number of colors of mana spent to cast this spell";
    }
}

