/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

public class CountersControllerCount
implements DynamicValue {
    private final CounterType counterType;

    public CountersControllerCount(CounterType counterType) {
        this.counterType = counterType;
    }

    protected CountersControllerCount(CountersControllerCount countersCount) {
        this.counterType = countersCount.counterType;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        UUID controllerId = sourceAbility.getControllerId();
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return 0;
        }
        return this.counterType != null ? player.getCountersCount(this.counterType) : 0;
    }

    @Override
    public CountersControllerCount copy() {
        return new CountersControllerCount(this);
    }

    public String toString() {
        return "1";
    }

    @Override
    public String getMessage() {
        return (this.counterType != null ? this.counterType.toString() + ' ' : "") + "counter on {this}'s controller";
    }
}

