/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileFromHandCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.game.Game;
import mage.util.CardUtil;

public enum ExileFromHandCostCardConvertedMana implements DynamicValue
{
    instance;


    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        for (Cost cost : sourceAbility.getCosts()) {
            if (!cost.isPaid() || !(cost instanceof ExileFromHandCost)) continue;
            int xValue = 0;
            for (Card card : ((ExileFromHandCost)cost).getCards()) {
                xValue += card.getManaValue();
            }
            return xValue;
        }
        return CardUtil.getSourceCostsTag(game, sourceAbility, "X", 0);
    }

    @Override
    public ExileFromHandCostCardConvertedMana copy() {
        return instance;
    }

    public String toString() {
        return "X";
    }

    @Override
    public String getMessage() {
        return "";
    }
}

