/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;

public class HalfValue
implements DynamicValue {
    private final DynamicValue value;
    private final boolean roundedUp;

    public HalfValue(DynamicValue value, boolean roundedUp) {
        this.value = value.copy();
        this.roundedUp = roundedUp;
    }

    protected HalfValue(HalfValue halfValue) {
        this.value = halfValue.value.copy();
        this.roundedUp = halfValue.roundedUp;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return (this.value.calculate(game, sourceAbility, effect) + (this.roundedUp ? 1 : 0)) / 2;
    }

    @Override
    public HalfValue copy() {
        return new HalfValue(this);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("half ").append(this.value.getMessage());
        if (this.roundedUp) {
            sb.append(", rounded up");
        } else {
            sb.append(", rounded down");
        }
        return sb.toString();
    }

    @Override
    public int getSign() {
        return this.value.getSign();
    }

    public String toString() {
        return "half ";
    }
}

