/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.filter.FilterPermanent;
import mage.game.Game;

public class PermanentsTargetOpponentControlsCount
implements DynamicValue {
    private final FilterPermanent filter;
    private final Integer multiplier;

    public PermanentsTargetOpponentControlsCount() {
        this(new FilterPermanent(), 1);
    }

    public PermanentsTargetOpponentControlsCount(FilterPermanent filter) {
        this(filter, 1);
    }

    public PermanentsTargetOpponentControlsCount(FilterPermanent filter, Integer multiplier) {
        this.filter = filter.copy();
        this.multiplier = multiplier;
    }

    protected PermanentsTargetOpponentControlsCount(PermanentsTargetOpponentControlsCount dynamicValue) {
        this.filter = dynamicValue.filter;
        this.multiplier = dynamicValue.multiplier;
    }

    @Override
    public PermanentsTargetOpponentControlsCount copy() {
        return new PermanentsTargetOpponentControlsCount(this);
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        UUID targetOpponentId = effect.getTargetPointer().getFirst(game, sourceAbility);
        if (targetOpponentId == null) {
            return 0;
        }
        int value = game.getBattlefield().countAll(this.filter, targetOpponentId, game);
        if (this.multiplier != null) {
            value *= this.multiplier.intValue();
        }
        return value;
    }

    public String toString() {
        return this.multiplier == null ? "X" : this.multiplier.toString();
    }

    @Override
    public String getMessage() {
        return (this.multiplier == null ? "the number of " : "") + this.filter.getMessage() + " target opponent controls";
    }

    @Override
    public int getSign() {
        return this.multiplier == null ? 1 : this.multiplier;
    }
}

