/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

public enum SourceControllerCountersCount implements DynamicValue
{
    ENERGY(CounterType.ENERGY),
    EXPERIENCE(CounterType.EXPERIENCE),
    RAD(CounterType.RAD);

    private final CounterType counterType;

    private SourceControllerCountersCount(CounterType counterType) {
        this.counterType = counterType;
    }

    @Override
    public SourceControllerCountersCount copy() {
        return this;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int amount = 0;
        Player player = game.getPlayer(sourceAbility.getControllerId());
        if (player != null) {
            amount = player.getCountersCount(this.counterType);
        }
        return amount;
    }

    public String toString() {
        return "1";
    }

    @Override
    public String getMessage() {
        return this.counterType.getName() + " counter you have";
    }
}

