/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;

public enum UrzaTerrainValue implements DynamicValue
{
    MINE(2, SubType.MINE),
    TOWER(3, SubType.TOWER),
    POWER_PLANT(2, SubType.POWER_PLANT);

    private final int value;
    private final SubType subType;
    private static final FilterPermanent mineFilter;
    private static final FilterPermanent towerFilter;
    private static final FilterPermanent powerPlantFilter;

    private UrzaTerrainValue(int value, SubType subType) {
        this.value = value;
        this.subType = subType;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        if (this.subType != SubType.MINE && game.getBattlefield().count(mineFilter, sourceAbility.getControllerId(), sourceAbility, game) < 1) {
            return 1;
        }
        if (this.subType != SubType.TOWER && game.getBattlefield().count(towerFilter, sourceAbility.getControllerId(), sourceAbility, game) < 1) {
            return 1;
        }
        if (this.subType != SubType.POWER_PLANT && game.getBattlefield().count(powerPlantFilter, sourceAbility.getControllerId(), sourceAbility, game) < 1) {
            return 1;
        }
        return this.value;
    }

    @Override
    public UrzaTerrainValue copy() {
        return this;
    }

    public String toString() {
        return "1 or " + this.value;
    }

    @Override
    public String getMessage() {
        return "";
    }

    static {
        mineFilter = new FilterControlledPermanent(SubType.MINE);
        towerFilter = new FilterControlledPermanent(SubType.TOWER);
        powerPlantFilter = new FilterControlledPermanent(SubType.POWER_PLANT);
        mineFilter.add(SubType.URZAS.getPredicate());
        towerFilter.add(SubType.URZAS.getPredicate());
        powerPlantFilter.add(SubType.URZAS.getPredicate());
    }
}

