/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.effects.AsThoughEffect;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.cards.CardWithSpellOption;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SpellOptionCard;
import mage.cards.SplitCard;
import mage.cards.SplitCardHalf;
import mage.constants.AbilityType;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

public abstract class AsThoughEffectImpl
extends ContinuousEffectImpl
implements AsThoughEffect {
    protected AsThoughEffectType type;

    public AsThoughEffectImpl(AsThoughEffectType type, Duration duration, Outcome outcome) {
        super(duration, outcome);
        this.type = type;
        this.effectType = EffectType.ASTHOUGH;
    }

    protected AsThoughEffectImpl(AsThoughEffectImpl effect) {
        super(effect);
        this.type = effect.type;
    }

    @Override
    public boolean applies(UUID objectId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        return this.applies(objectId, source, playerId, game);
    }

    @Override
    public AsThoughEffectType getAsThoughEffectType() {
        return this.type;
    }

    public boolean isAbilityAppliedForAlternateCast(Card cardToCheck, Ability affectedAbilityToCheck, UUID playerToCheck, Ability source) {
        return cardToCheck != null && playerToCheck.equals(source.getControllerId()) && cardToCheck.isOwnedBy(source.getControllerId()) && affectedAbilityToCheck instanceof ActivatedAbility && (affectedAbilityToCheck.getAbilityType() == AbilityType.SPELL || affectedAbilityToCheck.getAbilityType() == AbilityType.PLAY_LAND);
    }

    protected boolean allowCardToPlayWithoutMana(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        return this.allowCardToPlayWithoutMana(objectId, source, affectedControllerId, MageIdentifier.Default, game);
    }

    protected boolean allowCardToPlayWithoutMana(UUID objectId, Ability source, UUID affectedControllerId, MageIdentifier identifier, Game game) {
        Player player = game.getPlayer(affectedControllerId);
        Card card = game.getCard(objectId);
        if (card == null || player == null) {
            return false;
        }
        if (!card.isLand(game)) {
            if (card instanceof SplitCard) {
                SplitCardHalf leftCard = ((SplitCard)card).getLeftHalfCard();
                player.setCastSourceIdWithAlternateMana(leftCard.getId(), null, leftCard.getSpellAbility().getCosts(), identifier);
                SplitCardHalf rightCard = ((SplitCard)card).getRightHalfCard();
                player.setCastSourceIdWithAlternateMana(rightCard.getId(), null, rightCard.getSpellAbility().getCosts(), identifier);
            } else if (card instanceof ModalDoubleFacedCard) {
                ModalDoubleFacedCardHalf leftCard = ((ModalDoubleFacedCard)card).getLeftHalfCard();
                ModalDoubleFacedCardHalf rightCard = ((ModalDoubleFacedCard)card).getRightHalfCard();
                if (!leftCard.isLand(game)) {
                    player.setCastSourceIdWithAlternateMana(leftCard.getId(), null, leftCard.getSpellAbility().getCosts(), identifier);
                }
                if (!rightCard.isLand(game)) {
                    player.setCastSourceIdWithAlternateMana(rightCard.getId(), null, rightCard.getSpellAbility().getCosts(), identifier);
                }
            } else if (card instanceof CardWithSpellOption) {
                Card creatureCard = card.getMainCard();
                SpellOptionCard spellCard = ((CardWithSpellOption)card).getSpellCard();
                player.setCastSourceIdWithAlternateMana(creatureCard.getId(), null, creatureCard.getSpellAbility().getCosts(), identifier);
                player.setCastSourceIdWithAlternateMana(spellCard.getId(), null, spellCard.getSpellAbility().getCosts(), identifier);
            }
            player.setCastSourceIdWithAlternateMana(objectId, null, card.getSpellAbility().getCosts(), identifier);
        }
        return true;
    }
}

