/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

public class BecomesAttachedToCreatureSourceEffect
extends ReplacementEffectImpl {
    private final Effects baseEffects;
    private final String text;
    private final Condition condition;

    public BecomesAttachedToCreatureSourceEffect(Effect baseEffect) {
        this(baseEffect, "");
    }

    public BecomesAttachedToCreatureSourceEffect(Effect baseEffect, String text) {
        this(baseEffect, null, text);
    }

    public BecomesAttachedToCreatureSourceEffect(Effect baseEffect, Condition condition, String text) {
        super(Duration.WhileOnBattlefield, baseEffect.getOutcome(), false);
        this.baseEffects = new Effects(new Effect[0]);
        this.baseEffects.add(baseEffect);
        this.text = text;
        this.condition = condition;
    }

    protected BecomesAttachedToCreatureSourceEffect(BecomesAttachedToCreatureSourceEffect effect) {
        super(effect);
        this.baseEffects = effect.baseEffects.copy();
        this.text = effect.text;
        this.condition = effect.condition;
    }

    @Override
    public BecomesAttachedToCreatureSourceEffect copy() {
        return new BecomesAttachedToCreatureSourceEffect(this);
    }

    public void addEffect(Effect effect) {
        this.baseEffects.add(effect);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return GameEvent.EventType.ATTACH == event.getType();
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getSourceId().equals(source.getSourceId())) {
            return this.condition == null || this.condition.apply(game, source);
        }
        return false;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        for (Effect effect : this.baseEffects) {
            if (effect instanceof ContinuousEffect) {
                game.addEffect((ContinuousEffect)effect, source);
                continue;
            }
            effect.setValue("appliedEffects", event.getAppliedEffects());
            effect.apply(game, source);
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        return this.text == null || this.text.isEmpty() ? this.baseEffects.getText(mode) : this.text;
    }
}

