/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.PayCostToAttackBlockEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

public abstract class PayCostToAttackBlockEffectImpl
extends ReplacementEffectImpl
implements PayCostToAttackBlockEffect {
    protected final Cost cost;
    protected final ManaCosts manaCosts;
    protected final RestrictType restrictType;

    public PayCostToAttackBlockEffectImpl(Duration duration, Outcome outcome, RestrictType restrictType) {
        super(duration, outcome, false);
        this.restrictType = restrictType;
        this.cost = null;
        this.manaCosts = null;
    }

    public PayCostToAttackBlockEffectImpl(Duration duration, Outcome outcome, RestrictType restrictType, Cost cost) {
        super(duration, outcome, false);
        this.restrictType = restrictType;
        if (cost instanceof ManaCosts) {
            this.cost = null;
            this.manaCosts = (ManaCosts)cost;
        } else {
            this.cost = cost;
            this.manaCosts = null;
        }
    }

    protected PayCostToAttackBlockEffectImpl(PayCostToAttackBlockEffectImpl effect) {
        super(effect);
        this.cost = effect.cost != null ? effect.cost.copy() : null;
        this.manaCosts = effect.manaCosts != null ? effect.manaCosts.copy() : null;
        this.restrictType = effect.restrictType;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        switch (this.restrictType) {
            case ATTACK: {
                return event.getType() == GameEvent.EventType.DECLARE_ATTACKER;
            }
            case BLOCK: {
                return event.getType() == GameEvent.EventType.DECLARE_BLOCKER;
            }
            case ATTACK_AND_BLOCK: {
                return event.getType() == GameEvent.EventType.DECLARE_ATTACKER || event.getType() == GameEvent.EventType.DECLARE_BLOCKER;
            }
        }
        return false;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ManaCosts attackBlockManaTax = this.getManaCostToPay(event, source, game);
        if (attackBlockManaTax != null) {
            return this.handleManaCosts((ManaCosts)attackBlockManaTax.copy(), event, source, game);
        }
        Cost attackBlockOtherTax = this.getOtherCostToPay(event, source, game);
        if (attackBlockOtherTax != null) {
            return this.handleOtherCosts(attackBlockOtherTax.copy(), event, source, game);
        }
        return false;
    }

    private boolean handleManaCosts(ManaCosts attackBlockManaTax, GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player != null) {
            String chooseText = event.getType() == GameEvent.EventType.DECLARE_ATTACKER ? "Pay " + attackBlockManaTax.getText() + " to attack?" : "Pay " + attackBlockManaTax.getText() + " to block?";
            attackBlockManaTax.clearPaid();
            return !attackBlockManaTax.canPay(source, source, player.getId(), game) || !player.chooseUse(Outcome.Neutral, chooseText, source, game) || !(attackBlockManaTax instanceof ManaCostsImpl) || !attackBlockManaTax.payOrRollback(source, game, source, event.getPlayerId());
        }
        return false;
    }

    private boolean handleOtherCosts(Cost attackBlockOtherTax, GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player != null) {
            attackBlockOtherTax.clearPaid();
            return !attackBlockOtherTax.canPay(source, source, event.getPlayerId(), game) || !player.chooseUse(Outcome.Neutral, attackBlockOtherTax.getText() + " to " + (event.getType() == GameEvent.EventType.DECLARE_ATTACKER ? "attack?" : "block?"), source, game) || !attackBlockOtherTax.pay(source, game, source, event.getPlayerId(), false, null);
        }
        return false;
    }

    @Override
    public Cost getOtherCostToPay(GameEvent event, Ability source, Game game) {
        return this.cost;
    }

    @Override
    public ManaCosts getManaCostToPay(GameEvent event, Ability source, Game game) {
        return this.manaCosts;
    }

    @Override
    public boolean isCostless(GameEvent event, Ability source, Game game) {
        ManaCosts currentManaCosts = this.getManaCostToPay(event, source, game);
        if (currentManaCosts != null && currentManaCosts.manaValue() > 0) {
            return false;
        }
        return this.getOtherCostToPay(event, source, game) == null;
    }

    public static enum RestrictType {
        ATTACK("attack"),
        ATTACK_AND_BLOCK("attack or block"),
        BLOCK("block");

        private final String text;

        private RestrictType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

