/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import java.util.HashSet;
import java.util.Set;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class PreventDamageAndRemoveCountersWatcher
extends Watcher {
    private final Set<MageObjectReference> morRemovedCounterThisDamageBatch = new HashSet<MageObjectReference>();

    PreventDamageAndRemoveCountersWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_BATCH_COULD_HAVE_FIRED) {
            return;
        }
        this.morRemovedCounterThisDamageBatch.clear();
    }

    @Override
    public void reset() {
        super.reset();
        this.morRemovedCounterThisDamageBatch.clear();
    }

    boolean hadMORCounterRemovedThisBatch(MageObjectReference mor) {
        return this.morRemovedCounterThisDamageBatch.contains(mor);
    }

    void addMOR(MageObjectReference mor) {
        this.morRemovedCounterThisDamageBatch.add(mor);
    }
}

