/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public abstract class RequirementEffect
extends ContinuousEffectImpl {
    boolean playerRelated;

    public RequirementEffect(Duration duration) {
        this(duration, false);
    }

    public RequirementEffect(Duration duration, boolean playerRelated) {
        super(duration, Outcome.Detriment);
        this.effectType = EffectType.REQUIREMENT;
        this.playerRelated = playerRelated;
    }

    protected RequirementEffect(RequirementEffect effect) {
        super(effect);
        this.playerRelated = effect.playerRelated;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public abstract boolean applies(Permanent var1, Ability var2, Game var3);

    public abstract boolean mustAttack(Game var1);

    public abstract boolean mustBlock(Game var1);

    public boolean mustBlockAny(Game game) {
        return false;
    }

    public boolean mustBlockAllAttackers(Game game) {
        return false;
    }

    public UUID mustAttackDefender(Ability source, Game game) {
        return null;
    }

    public UUID mustBlockAttacker(Ability source, Game game) {
        return null;
    }

    public UUID mustBlockAttackerIfElseUnblocked(Ability source, Game game) {
        return null;
    }

    public int getMinNumberOfBlockers() {
        return 0;
    }

    public UUID playerMustBeAttackedIfAble(Ability source, Game game) {
        return null;
    }

    public boolean isPlayerRelated() {
        return this.playerRelated;
    }
}

