/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DelayedAddMainPhaseAbility;
import mage.constants.Outcome;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.turn.TurnMod;

public class AddCombatAndMainPhaseEffect
extends OneShotEffect {
    public AddCombatAndMainPhaseEffect() {
        super(Outcome.Benefit);
        this.staticText = "After this main phase, there is an additional combat phase followed by an additional main phase";
    }

    protected AddCombatAndMainPhaseEffect(AddCombatAndMainPhaseEffect effect) {
        super(effect);
    }

    @Override
    public AddCombatAndMainPhaseEffect copy() {
        return new AddCombatAndMainPhaseEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (game.getTurnPhaseType().isMain()) {
            TurnMod combat = new TurnMod(source.getControllerId()).withExtraPhase(TurnPhase.COMBAT, TurnPhase.POSTCOMBAT_MAIN);
            game.getState().getTurnMods().add(combat);
            DelayedAddMainPhaseAbility delayedTriggeredAbility = new DelayedAddMainPhaseAbility();
            delayedTriggeredAbility.setConnectedTurnMod(combat.getId());
            game.addDelayedTriggeredAbility(delayedTriggeredAbility, source);
            return true;
        }
        return false;
    }
}

