/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class AttacksIfAbleTargetPlayerSourceEffect
extends RequirementEffect {
    public AttacksIfAbleTargetPlayerSourceEffect() {
        super(Duration.EndOfCombat);
        this.staticText = "{this} attacks that player this combat if able";
    }

    protected AttacksIfAbleTargetPlayerSourceEffect(AttacksIfAbleTargetPlayerSourceEffect effect) {
        super(effect);
    }

    @Override
    public AttacksIfAbleTargetPlayerSourceEffect copy() {
        return new AttacksIfAbleTargetPlayerSourceEffect(this);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    @Override
    public boolean mustAttack(Game game) {
        return true;
    }

    @Override
    public boolean mustBlock(Game game) {
        return false;
    }

    @Override
    public UUID mustAttackDefender(Ability source, Game game) {
        return this.getTargetPointer().getFirst(game, source);
    }
}

