/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.ChoicePlaneswalkerType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class ChoosePlaneswalkerTypeEffect
extends OneShotEffect {
    public ChoosePlaneswalkerTypeEffect(Outcome outcome) {
        super(outcome);
        this.staticText = "choose a planeswalker type";
    }

    protected ChoosePlaneswalkerTypeEffect(ChoosePlaneswalkerTypeEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        ChoicePlaneswalkerType typeChoice;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getPermanentEntering(source.getSourceId());
        if (mageObject == null) {
            mageObject = game.getObject(source);
        }
        if (controller != null && mageObject != null && controller.choose(this.outcome, typeChoice = new ChoicePlaneswalkerType(mageObject), game)) {
            game.informPlayers(mageObject.getName() + ": " + controller.getLogName() + " has chosen " + typeChoice.getChoice());
            game.getState().setValue(source.getSourceId() + "_type", SubType.byDescription(typeChoice.getChoice()));
            if (mageObject instanceof Permanent) {
                ((Permanent)mageObject).addInfo("chosen type", CardUtil.addToolTipMarkTags("Chosen type: " + typeChoice.getChoice()), game);
            }
            return true;
        }
        return false;
    }

    @Override
    public ChoosePlaneswalkerTypeEffect copy() {
        return new ChoosePlaneswalkerTypeEffect(this);
    }

    public static SubType getChosenPlaneswalkerType(UUID objectId, Game game) {
        return ChoosePlaneswalkerTypeEffect.getChosenPlaneswalkerType(objectId, game, "_type");
    }

    public static SubType getChosenPlaneswalkerType(UUID objectId, Game game, String typePostfix) {
        SubType planeswalkerType = null;
        Object savedPlaneswalkerType = game.getState().getValue(objectId + typePostfix);
        if (savedPlaneswalkerType != null) {
            planeswalkerType = SubType.byDescription(savedPlaneswalkerType.toString());
        }
        return planeswalkerType;
    }
}

